<?php
require "connection.php";

$response = array();

function addDonateItem($con, $item_title, $item_description, $category_name, $location_country, $location_city, $location_lat, $location_lng, $item_condition, $user_id, $files) {
    $upload_directory = "uploads/donate_items/";
    $image_paths = [];

    // Check if files were uploaded
    if (!empty($files['name'][0])) {
        foreach ($files['name'] as $key => $file_name) {
            $file_tmp = $files['tmp_name'][$key];
            $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

            // Keep original file name and append a random number
            $baseFileName = pathinfo($file_name, PATHINFO_FILENAME);
            $newFileName = $baseFileName . '_' . uniqid() . '.' . $file_ext;
            $targetFilePath = $uploadDir . $newFileName;

            if (move_uploaded_file($file_tmp, $targetFilePath)) {
                // Store the correct file path without backslashes
                $image_paths[] = str_replace("\\", "/", $targetFilePath);
            } else {
                echo "Failed to upload image: " . $file_name;
                return;
            }
        }
    }

    // Convert the array of uploaded file paths to a JSON string
    $images_json = json_encode($image_paths, JSON_UNESCAPED_SLASHES);

        
            $insertQuery = "INSERT INTO donate_tbl (item_title, item_description, category_name, location_country, location_city, location_lat, location_lng, item_condition, user_id, images) 
                            VALUES ('$item_title', '$item_description', '$category_name', '$location_country', '$location_city', '$location_lat', '$location_lng', '$item_condition', '$user_id', '$images_json')";

            $result = mysqli_query($con, $insertQuery);

            if ($result) {
                return array("error" => "200", "message" => "Item added successfully");
            } else {
                return array("error" => "Error executing query: " . mysqli_error($con));
            }
        
     
}

function updateDonateItem($con, $donate_id, $item_title = null, $item_description = null, $category_name = null, $location_country = null, $location_city = null, $location_lat = null, $location_lng = null, $item_condition = null, $files = null, $existingImageUrls = null) {
    $uploadDir = 'uploads/donate_items/';
    $image_paths = [];

    // Handle existing image URLs
    if (!empty($existingImageUrls)) {
        $existingImageUrls = stripslashes($existingImageUrls);
        $existingImageUrls = trim($existingImageUrls, '[]"');
        $image_paths = array_map('trim', explode(',', $existingImageUrls));
    }

    // Handle new file uploads if new files are provided
    if ($files && $files['error'][0] == 0) {
        foreach ($files['name'] as $key => $fileName) {
            $file_tmp = $files['tmp_name'][$key];
            $file_ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

            $newFileName = pathinfo($fileName, PATHINFO_FILENAME) . '_' . uniqid() . '.' . $file_ext;
            $targetFilePath = $uploadDir . $newFileName;

            if (move_uploaded_file($file_tmp, $targetFilePath)) {
                $image_paths[] = $targetFilePath;
            } else {
                return array("error" => "002", "message" => "Failed to upload image: " . $fileName);
            }
        }
    }

    $images_json = json_encode($image_paths, JSON_UNESCAPED_SLASHES);

    $sql = "UPDATE donate_tbl SET updated_at = CURRENT_TIMESTAMP";
    $params = [];
    $types = "";

    if ($item_title !== null) {
        $sql .= ", item_title = ?";
        $params[] = $item_title;
        $types .= "s";
    }
    if ($item_description !== null) {
        $sql .= ", item_description = ?";
        $params[] = $item_description;
        $types .= "s";
    }
    if ($category_name !== null) {
        $sql .= ", category_name = ?";
        $params[] = $category_name;
        $types .= "s";
    }
    if ($location_country !== null) {
        $sql .= ", location_country = ?";
        $params[] = $location_country;
        $types .= "s";
    }
    if ($location_city !== null) {
        $sql .= ", location_city = ?";
        $params[] = $location_city;
        $types .= "s";
    }
    if ($location_lat !== null) {
        $sql .= ", location_lat = ?";
        $params[] = $location_lat;
        $types .= "s";
    }
    if ($location_lng !== null) {
        $sql .= ", location_lng = ?";
        $params[] = $location_lng;
        $types .= "s";
    }
    if ($item_condition !== null) {
        $sql .= ", item_condition = ?";
        $params[] = $item_condition;
        $types .= "s";
    }
    if (!empty($images_json)) {
        $sql .= ", images = ?";
        $params[] = $images_json;
        $types .= "s";
    }

    $sql .= " WHERE donate_id = ?";
    $params[] = $donate_id;
    $types .= "i";

    $stmt = $con->prepare($sql);

    if ($stmt) {
        $stmt->bind_param($types, ...$params);

        if ($stmt->execute()) {
            return array("error" => "200", "message" => "Item updated successfully");
        } else {
            return array("error" => "Error: " . $stmt->error);
        }

        $stmt->close();
    } else {
        return array("error" => "Error in preparing statement: " . $con->error);
    }
}

function deleteDonateItem($con, $donate_id) {
    if (!is_numeric($donate_id)) {
        return array("error" => "400", "message" => "Invalid donate_id provided.");
    }

    $stmt = $con->prepare("SELECT images FROM donate_tbl WHERE donate_id = ?");
    $stmt->bind_param("i", $donate_id);
    $stmt->execute();
    $stmt->bind_result($images);
    $stmt->fetch();
    $stmt->close();

    if ($images === null) {
        return array("error" => "404", "message" => "Item not found or no images associated with this item.");
    }

    $stmt = $con->prepare("DELETE FROM donate_tbl WHERE donate_id = ?");
    $stmt->bind_param("i", $donate_id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            if (!empty($images)) {
                $imageArray = json_decode($images, true);
                if (is_array($imageArray)) {
                    foreach ($imageArray as $image) {
                        if (file_exists($image)) {
                            unlink($image);
                        }
                    }
                }
            }
            return array("error" => "200", "message" => "Item and associated images deleted successfully!");
        } else {
            return array("error" => "404", "message" => "Item not found.");
        }
    } else {
        return array("error" => "Error executing query: " . $stmt->error);
    }

    $stmt->close();
}

// Determine action and call respective function
$action = isset($_POST['action']) ? $_POST['action'] : null;

if ($action) {
    $item_title = mysqli_real_escape_string($con, $_POST["item_title"] ?? "");
    $item_description = mysqli_real_escape_string($con, $_POST["item_description"] ?? "");
    $category_name = mysqli_real_escape_string($con, $_POST["category_name"] ?? "");
    $location_country = mysqli_real_escape_string($con, $_POST["location_country"] ?? "");
    $location_city = mysqli_real_escape_string($con, $_POST["location_city"] ?? "");
    $location_lat = mysqli_real_escape_string($con, $_POST["location_lat"] ?? "");
    $location_lng = mysqli_real_escape_string($con, $_POST["location_lng"] ?? "");
    $item_condition = mysqli_real_escape_string($con, $_POST["item_condition"] ?? "");
    $user_id = intval($_POST["user_id"] ?? 0);
    $files = $_FILES["images"] ?? null;
    $existingImageUrls = isset($_POST['existingImageUrls']) ? $_POST['existingImageUrls'] : null;

    switch ($action) {
        case "add":
            $response = addDonateItem($con, $item_title, $item_description, $category_name, $location_country, $location_city, $location_lat, $location_lng, $item_condition, $user_id, $files);
            break;
        case "update":
            $donate_id = intval($_POST["donate_id"] ?? 0);
            $response = updateDonateItem($con, $donate_id, $item_title, $item_description, $category_name, $location_country, $location_city, $location_lat, $location_lng, $item_condition, $files, $existingImageUrls);
            break;
        case "delete":
            $donate_id = intval($_POST["donate_id"] ?? 0);
            $response = deleteDonateItem($con, $donate_id);
            break;
        default:
            $response = array("error" => "400", "message" => "Invalid action provided.");
    }
} else {
    $response = array("error" => "400", "message" => "Action not provided.");
}

echo json_encode($response);
?>
