<?php

// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

require "connection.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'];

    switch ($action) {
        case 'add':
            $item_title = $_POST['item_title'];
            $rent_price = $_POST['rent_price'];
            $rent_duration = $_POST['rent_duration'];
            $item_description = $_POST['item_description'];
            $category_name = $_POST['category_name'];
            $subcategory_name = $_POST['subcategory_name'];
            $childcategory_name = $_POST['childcategory_name'];
            $location_country = $_POST['location_country'];
            $location_city = $_POST['location_city'];
            $location_lat = $_POST['location_lat'];
            $location_lng = $_POST['location_lng'];
            $condition = $_POST['condition'];
            $user_id = $_POST['user_id'];
            $files = $_FILES['images'];
            addItemToRent($item_title, $rent_price, $rent_duration, $item_description, $category_name, $subcategory_name, $childcategory_name, $location_country, $location_city, $location_lat, $location_lng, $condition, $user_id, $files);
            break;

        case 'update':
            $id = $_POST['id'];
            $item_title = $_POST['item_title'] ?? null;
            $rent_price = $_POST['rent_price'] ?? null;
            $rent_duration = $_POST['rent_duration'] ?? null;
            $item_description = $_POST['item_description'] ?? null;
            $category_name = $_POST['category_name'] ?? null;
            $subcategory_name = $_POST['subcategory_name'] ?? null;
            $childcategory_name = $_POST['childcategory_name'] ?? null;
            $location_country = $_POST['location_country'] ?? null;
            $location_city = $_POST['location_city'] ?? null;
            $location_lat = $_POST['location_lat'] ?? null;
            $location_lng = $_POST['location_lng'] ?? null;
            $condition = $_POST['condition'] ?? null;
            $files = $_FILES['images'] ?? null;
            $existingImageUrls = isset($_POST['existingImageUrls']) ? $_POST['existingImageUrls'] : null;
            print_r($files);
            updateRentItem($id, $item_title, $rent_price, $rent_duration, $item_description, $category_name, $subcategory_name, $childcategory_name, $location_country, $location_city, $location_lat, $location_lng, $condition, $files, $existingImageUrls);
            break;

        case 'delete':
            $id = $_POST['id'];
            deleteRentItem($id);
            break;
            
            case "setPremiumStatus":
                $id = intval($_POST["id"]);
                $is_premium = filter_var($_POST["is_premium"], FILTER_VALIDATE_BOOLEAN);
                 if (isset($_POST["duration_in_days"]) && is_numeric($_POST["duration_in_days"])) {
                        $duration_in_days = intval($_POST["duration_in_days"]);
                    } else {
                        $duration_in_days = null; // Set to null if not provided or invalid
                    }
                setPremiumStatus($con, $id, $is_premium, $duration_in_days);
            break;

        default:
            echo "Invalid action specified.";
    }
} else {
    echo "Invalid request method.";
}


function addItemToRent($item_title, $rent_price, $rent_duration, $item_description, $category_name, $subcategory_name, $childcategory_name, $location_country, $location_city, $location_lat, $location_lng, $condition, $user_id, $files) {
    global $con;

    $uploadDir = 'uploads/rent_items/';
    $image_paths = [];

    // Check if files were uploaded
    if (!empty($files['name'][0])) {
        foreach ($files['name'] as $key => $file_name) {
            $file_tmp = $files['tmp_name'][$key];
            $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

            // Keep original file name and append a random number
            $baseFileName = pathinfo($file_name, PATHINFO_FILENAME);
            $newFileName = $baseFileName . '_' . uniqid() . '.' . $file_ext;
            $targetFilePath = $uploadDir . $newFileName;

            if (move_uploaded_file($file_tmp, $targetFilePath)) {
                // Store the correct file path without backslashes
                $image_paths[] = str_replace("\\", "/", $targetFilePath);
            } else {
                echo "Failed to upload image: " . $file_name;
                return;
            }
        }
    }

    // Convert the array of uploaded file paths to a JSON string
    $images_json = json_encode($image_paths, JSON_UNESCAPED_SLASHES);

    // Create the SQL query with directly inserted values
    $sql = "
        INSERT INTO rent_tbl 
            (item_title, rent_price, rent_duration, item_description, category_name, subcategory_name, childcategory_name, location_country, location_city, location_lat, location_lng, `condition`, user_id, images) 
        VALUES 
            ('$item_title', '$rent_price', '$rent_duration', '$item_description', '$category_name', '$subcategory_name', '$childcategory_name', '$location_country', '$location_city', '$location_lat', '$location_lng', '$condition', '$user_id', '$images_json')
    ";

    // Execute the query
    if ($con->query($sql) === TRUE) {
        echo "Item added to rent_tbl successfully!";
    } else {
        echo "Error: " . $con->error;
    }
}



function updateRentItem($id, $item_title = null, $rent_price = null, $rent_duration = null, $item_description = null, $category_name = null, $subcategory_name = null, $childcategory_name = null, $location_country = null, $location_city = null, $location_lat = null, $location_lng = null, $condition = null, $files = null, $existingImageUrls = null) {
    global $con;

    $uploadDir = 'uploads/rent_items/';
    $image_paths = [];

    // Handle existing image URLs
    if (!empty($existingImageUrls)) {
        // Decode JSON and remove any unwanted characters
        $existingImageUrls = stripslashes($existingImageUrls); // Remove backslashes
        $existingImageUrls = trim($existingImageUrls, '[]"'); // Remove surrounding quotes and brackets
        $image_paths = array_map('trim', explode(',', $existingImageUrls)); // Split by comma and trim whitespace
    }

    // Handle new file uploads if new files are provided
    if ($files && $files['error'][0] == 0) {
        foreach ($files['name'] as $key => $fileName) {
            $file_tmp = $files['tmp_name'][$key];
            $file_ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

            // Create a new filename with a random number to avoid conflicts
            $newFileName = pathinfo($fileName, PATHINFO_FILENAME) . '_' . uniqid() . '.' . $file_ext;
            $targetFilePath = $uploadDir . $newFileName;

            if (move_uploaded_file($file_tmp, $targetFilePath)) {
                $image_paths[] = $targetFilePath;
            } else {
                echo "Failed to upload image: " . $fileName;
                return;
            }
        }
    }

    // Convert the array of image paths to a JSON string without escaping slashes
    $images_json = json_encode($image_paths, JSON_UNESCAPED_SLASHES);

    // Only update the `images` field if there are images to update
    $sql = "UPDATE rent_tbl SET updated_at = CURRENT_TIMESTAMP";
    $params = [];
    $types = "";

    if ($item_title !== null) {
        $sql .= ", item_title = ?";
        $params[] = $item_title;
        $types .= "s";
    }
    if ($rent_price !== null) {
        $sql .= ", rent_price = ?";
        $params[] = $rent_price;
        $types .= "d";
    }
    if ($rent_duration !== null) {
        $sql .= ", rent_duration = ?";
        $params[] = $rent_duration;
        $types .= "s";
    }
    if ($item_description !== null) {
        $sql .= ", item_description = ?";
        $params[] = $item_description;
        $types .= "s";
    }
    if ($category_name !== null) {
        $sql .= ", category_name = ?";
        $params[] = $category_name;
        $types .= "s";
    }
    if ($subcategory_name !== null) {
        $sql .= ", subcategory_name = ?";
        $params[] = $subcategory_name;
        $types .= "s";
    }
    if ($childcategory_name !== null) {
        $sql .= ", childcategory_name = ?";
        $params[] = $childcategory_name;
        $types .= "s";
    }
    if ($location_country !== null) {
        $sql .= ", location_country = ?";
        $params[] = $location_country;
        $types .= "s";
    }
    if ($location_city !== null) {
        $sql .= ", location_city = ?";
        $params[] = $location_city;
        $types .= "s";
    }
    if ($location_lat !== null) {
        $sql .= ", location_lat = ?";
        $params[] = $location_lat;
        $types .= "d";
    }
    if ($location_lng !== null) {
        $sql .= ", location_lng = ?";
        $params[] = $location_lng;
        $types .= "d";
    }
    if ($condition !== null) {
        $sql .= ", `condition` = ?";
        $params[] = $condition;
        $types .= "s";
    }
    if (!empty($images_json)) {
        $sql .= ", images = ?";
        $params[] = $images_json;
        $types .= "s";
    }

    $sql .= " WHERE id = ?";
    $params[] = $id;
    $types .= "i";

    $stmt = $con->prepare($sql);

    if ($stmt) {
        $stmt->bind_param($types, ...$params);

        if ($stmt->execute()) {
            echo "Item updated successfully!";
        } else {
            echo "Error: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo "Error in preparing statement: " . $con->error;
    }
}


function deleteRentItem($id) {
    global $con;

    // Get the images field for the item to be deleted
    $stmt = $con->prepare("SELECT images FROM rent_tbl WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->bind_result($images);
    $stmt->fetch();
    $stmt->close();

    // Delete the item from the database
    $stmt = $con->prepare("DELETE FROM rent_tbl WHERE id = ?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            // If deletion is successful, delete the images from the server
            if (!empty($images)) {
                $imageArray = explode(",", $images);
                foreach ($imageArray as $image) {
                    if (file_exists($image)) {
                        unlink($image); // Delete the file from the server
                    }
                }
            }
            echo "Item and associated images deleted successfully!";
        } else {
            echo "Item not found.";
        }
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
}


function setPremiumStatus($con, $id, $is_premium, $premium_duration_days = null) {
    // Convert boolean values to integers
    if (is_bool($is_premium)) {
        $is_premium = $is_premium ? 1 : 0;
    }
    
    

    // Determine the premium expiration date
    if ($premium_duration_days !== null && is_int($premium_duration_days) && $premium_duration_days > 0) {
        // Calculate the expiration date based on the provided duration
        $premium_until = date('Y-m-d H:i:s', strtotime("+$premium_duration_days days"));
    } else {
        // Set the expiration date to NULL if duration is not provided or invalid
        $premium_until = null;
    }

    // Prepare the SQL query
    $sql = "UPDATE rent_tbl SET is_premium = ?, premium_expiry = ? WHERE id = ?";
    
 

    if ($stmt = $con->prepare($sql)) {
           
        // Bind parameters
        if ($premium_until === null) {
            // Use `NULL` for `premium_until` and set its type to `s` (string) in `bind_param`
            $stmt->bind_param("is", $is_premium, $id);
        } else {
            $stmt->bind_param("isi", $is_premium, $premium_until, $id);
        }

        // Execute the query
        if ($stmt->execute()) {
            echo json_encode(array("error" => "200", "message" => "Premium status updated successfully"));
        } else {
            echo json_encode(array("error" => "Error executing query: " . $stmt->error));
        }

        // Close the statement
        $stmt->close();
    } else {
        // Return the error if the statement couldn't be prepared
        return json_encode(array("error" => "Error preparing statement: " . $con->error));
    }
}





?>