<?php
// Database connection
include 'connection.php'; // Adjust the path as needed

function searchRentItems($item_title = null, $category_name = null, $subcategory_name = null, $childcategory_name = null, $location_country = null, $location_city = null, $condition = null) {
    global $con;

    // Start with the base SQL query
    $sql = "SELECT * FROM rent_tbl WHERE 1=1";
    $params = [];
    $types = "";

    // Append conditions based on provided filters
    if ($item_title !== null) {
        $sql .= " AND item_title LIKE ?";
        $params[] = '%' . $item_title . '%';
        $types .= "s";
    }
    if ($category_name !== null) {
        $sql .= " AND category_name = ?";
        $params[] = $category_name;
        $types .= "s";
    }
    if ($subcategory_name !== null) {
        $sql .= " AND subcategory_name = ?";
        $params[] = $subcategory_name;
        $types .= "s";
    }
    if ($childcategory_name !== null) {
        $sql .= " AND childcategory_name = ?";
        $params[] = $childcategory_name;
        $types .= "s";
    }
    if ($location_country !== null) {
        $sql .= " AND location_country = ?";
        $params[] = $location_country;
        $types .= "s";
    }
    if ($location_city !== null) {
        $sql .= " AND location_city = ?";
        $params[] = $location_city;
        $types .= "s";
    }
    if ($condition !== null) {
        $sql .= " AND `condition` = ?";
        $params[] = $condition;
        $types .= "s";
    }

    // Add sorting logic
    $sql .= " ORDER BY 
        CASE 
            WHEN is_premium = 1 AND premium_expiry >= NOW() THEN 1 
            ELSE 2 
        END, 
        id DESC"; // Sort item_title in descending order within each priority group

    // Prepare and execute the query
    $stmt = $con->prepare($sql);

    if ($stmt) {
        if ($types) {
            $stmt->bind_param($types, ...$params);
        }

        $stmt->execute();
        $result = $stmt->get_result();

        // Fetch results
        $items = $result->fetch_all(MYSQLI_ASSOC);

        // Decode JSON images field to remove extra escape characters
        foreach ($items as &$item) {
            if (isset($item['images'])) {
                $decodedImages = json_decode($item['images'], true); // Decode JSON string to PHP array
                if (json_last_error() === JSON_ERROR_NONE) {
                    $item['images'] = $decodedImages; // Assign decoded array back
                } else {
                    // Handle JSON decoding error
                    $item['images'] = [];
                }
            }
        }

        // Return results as JSON
        header('Content-Type: application/json');
        echo json_encode($items, JSON_UNESCAPED_SLASHES); // Encode back to JSON without escaping slashes

        $stmt->close();
    } else {
        echo "Error preparing statement: " . $con->error;
    }
}



// Check if POST data is available
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $item_title = isset($_POST['item_title']) ? $_POST['item_title'] : null;
    $category_name = isset($_POST['category_name']) ? $_POST['category_name'] : null;
    $subcategory_name = isset($_POST['subcategory_name']) ? $_POST['subcategory_name'] : null;
    $childcategory_name = isset($_POST['childcategory_name']) ? $_POST['childcategory_name'] : null;
    $location_country = isset($_POST['location_country']) ? $_POST['location_country'] : null;
    $location_city = isset($_POST['location_city']) ? $_POST['location_city'] : null;
    $condition = isset($_POST['condition']) ? $_POST['condition'] : null;

    searchRentItems($item_title, $category_name, $subcategory_name, $childcategory_name, $location_country, $location_city, $condition);
}
?>
