<?php
require "connection.php";
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$response = array();

function addItem($con, $item_title, $item_price, $item_description, $category_name, $subcategory_name, $childcategory_name, $location_country, $location_city, $location_lat, $location_lng, $item_condition, $user_id, $images) {
    $upload_directory = "uploads/sell_items/";
    $image_paths = array();

    if (!empty($images['name'][0])) {
        if (!is_array($images['name'])) {
            $images = array(
                'name'     => array($images['name']),
                'type'     => array($images['type']),
                'tmp_name' => array($images['tmp_name']),
                'error'    => array($images['error']),
                'size'     => array($images['size'])
            );
        }

        foreach ($images['name'] as $key => $image_name) {
            $image_temp = $images['tmp_name'][$key];
            $image_path = $upload_directory . $image_name;

            $imageFileType = strtolower(pathinfo($image_path, PATHINFO_EXTENSION));
            if (in_array($imageFileType, array("jpg", "jpeg", "png", "gif"))) {
                if (move_uploaded_file($image_temp, $image_path)) {
                    $image_paths[] = $image_path;
                } else {
                    return array("error" => "002", "message" => "Failed to upload one or more images.");
                }
            } else {
                return array("error" => "003", "message" => "Invalid image format. Please upload JPG, JPEG, PNG, or GIF.");
            }
        }

        if (count($image_paths) > 0) {
            $image_paths_json = json_encode($image_paths);
            $insertQuery = "INSERT INTO sell_tbl (item_title, item_price, item_description, category_name, subcategory_name, childcategory_name, location_country, location_city, location_lat, location_lng, item_condition, user_id, images) 
                            VALUES ('$item_title', '$item_price', '$item_description', '$category_name', '$subcategory_name', '$childcategory_name', '$location_country', '$location_city', '$location_lat', '$location_lng', '$item_condition', '$user_id', '$image_paths_json')";

            $result = mysqli_query($con, $insertQuery);

            if ($result) {
                return array("error" => "200", "message" => "Product added successfully");
            } else {
                return array("error" => "Error executing query: " . mysqli_error($con));
            }
        } else {
            return array("error" => "003", "message" => "No valid images provided.");
        }
    } else {
        return array("error" => "003", "message" => "Images not provided or invalid format.");
    }
}

function updateItem($con, $sell_id, $item_title = null, $item_price = null, $item_description = null, $category_name = null, $subcategory_name = null, $childcategory_name = null, $location_country = null, $location_city = null, $location_lat = null, $location_lng = null, $item_condition = null, $files = null, $existingImageUrls = null) {
    $uploadDir = 'uploads/sell_items/';
    $image_paths = [];

    // Handle existing image URLs
    if (!empty($existingImageUrls)) {
        // Decode JSON and remove any unwanted characters
        $existingImageUrls = stripslashes($existingImageUrls); // Remove backslashes
        $existingImageUrls = trim($existingImageUrls, '[]"'); // Remove surrounding quotes and brackets
        $image_paths = array_map('trim', explode(',', $existingImageUrls)); // Split by comma and trim whitespace
    }

    // Handle new file uploads if new files are provided
    if ($files && $files['error'][0] == 0) {
        foreach ($files['name'] as $key => $fileName) {
            $file_tmp = $files['tmp_name'][$key];
            $file_ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

            // Create a new filename with a random number to avoid conflicts
            $newFileName = pathinfo($fileName, PATHINFO_FILENAME) . '_' . uniqid() . '.' . $file_ext;
            $targetFilePath = $uploadDir . $newFileName;

            if (move_uploaded_file($file_tmp, $targetFilePath)) {
                $image_paths[] = $targetFilePath;
            } else {
                return array("error" => "002", "message" => "Failed to upload image: " . $fileName);
            }
        }
    }

    // Convert the array of image paths to a JSON string without escaping slashes
    $images_json = json_encode($image_paths, JSON_UNESCAPED_SLASHES);

    // Only update the `images` field if there are images to update
    $sql = "UPDATE sell_tbl SET updated_at = CURRENT_TIMESTAMP";
    $params = [];
    $types = "";

    if ($item_title !== null) {
        $sql .= ", item_title = ?";
        $params[] = $item_title;
        $types .= "s";
    }
    if ($item_price !== null) {
        $sql .= ", item_price = ?";
        $params[] = $item_price;
        $types .= "d";
    }
    if ($item_description !== null) {
        $sql .= ", item_description = ?";
        $params[] = $item_description;
        $types .= "s";
    }
    if ($category_name !== null) {
        $sql .= ", category_name = ?";
        $params[] = $category_name;
        $types .= "s";
    }
    if ($subcategory_name !== null) {
        $sql .= ", subcategory_name = ?";
        $params[] = $subcategory_name;
        $types .= "s";
    }
    if ($childcategory_name !== null) {
        $sql .= ", childcategory_name = ?";
        $params[] = $childcategory_name;
        $types .= "s";
    }
    if ($location_country !== null) {
        $sql .= ", location_country = ?";
        $params[] = $location_country;
        $types .= "s";
    }
    if ($location_city !== null) {
        $sql .= ", location_city = ?";
        $params[] = $location_city;
        $types .= "s";
    }
    if ($location_lat !== null) {
        $sql .= ", location_lat = ?";
        $params[] = $location_lat;
        $types .= "d";
    }
    if ($location_lng !== null) {
        $sql .= ", location_lng = ?";
        $params[] = $location_lng;
        $types .= "d";
    }
    if ($item_condition !== null) {
        $sql .= ", item_condition = ?";
        $params[] = $item_condition;
        $types .= "s";
    }
    if (!empty($images_json)) {
        $sql .= ", images = ?";
        $params[] = $images_json;
        $types .= "s";
    }

    $sql .= " WHERE sell_id = ?";
    $params[] = $sell_id;
    $types .= "i";

    $stmt = $con->prepare($sql);

    if ($stmt) {
        $stmt->bind_param($types, ...$params);

        if ($stmt->execute()) {
            return array("error" => "200", "message" => "Product updated successfully");
        } else {
            return array("error" => "Error: " . $stmt->error);
        }

        $stmt->close();
    } else {
        return array("error" => "Error in preparing statement: " . $con->error);
    }
}



function deleteItem($con, $sell_id) {
    // Debugging: Check the type and value of sell_id
    echo $sell_id;
    if (!is_numeric($sell_id)) {
        return array("error" => "400", "message" => "Invalid sell_id provided.");
    }
    
    print_r($sell_id);

    // Get the images field for the item to be deleted
    $stmt = $con->prepare("SELECT images FROM sell_tbl WHERE sell_id = ?");
    $stmt->bind_param("i", $sell_id);
    $stmt->execute();
    $stmt->bind_result($images);
    $stmt->fetch();
    $stmt->close();

    // Check if the images field was fetched properly
    if ($images === null) {
        return array("error" => "404", "message" => "Item not found or no images associated with this item.");
    }

    // Delete the item from the database
    $stmt = $con->prepare("DELETE FROM sell_tbl WHERE sell_id = ?");
    $stmt->bind_param("i", $sell_id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            // If deletion is successful, delete the images from the server
            if (!empty($images)) {
                $imageArray = json_decode($images, true);
                if (is_array($imageArray)) {
                    foreach ($imageArray as $image) {
                        if (file_exists($image)) {
                            unlink($image); // Delete the file from the server
                        }
                    }
                }
            }
            return array("error" => "200", "message" => "Product and associated images deleted successfully!");
        } else {
            return array("error" => "404", "message" => "Item not found.");
        }
    } else {
        return array("error" => "Error executing query: " . $stmt->error);
    }

    $stmt->close();
}

function setPremiumStatus($con, $sell_id, $is_premium, $premium_duration_days = null) {
    // Convert boolean values to integers
    if (is_bool($is_premium)) {
        $is_premium = $is_premium ? 1 : 0;
    }

    // Determine the premium expiration date
    if ($premium_duration_days !== null && is_int($premium_duration_days) && $premium_duration_days > 0) {
        // Calculate the expiration date based on the provided duration
        $premium_until = date('Y-m-d H:i:s', strtotime("+$premium_duration_days days"));
    } else {
        // Set the expiration date to NULL if duration is not provided or invalid
        $premium_until = null;
    }

    // Prepare the SQL query
    $sql = "UPDATE sell_tbl SET is_premium = ?, premium_expiry = ? WHERE sell_id = ?";

    if ($stmt = $con->prepare($sql)) {
        // Bind parameters
        // Note: 's' for string to handle the NULL case
        $stmt->bind_param("isi", $is_premium, $premium_until, $sell_id);

        // Execute the query
        if ($stmt->execute()) {
            return array("error" => "200", "message" => "Premium status updated successfully");
        } else {
            return array("error" => "Error executing query: " . $stmt->error);
        }

        // Close the statement
        $stmt->close();
    } else {
        // Return the error if the statement couldn't be prepared
        return array("error" => "Error preparing statement: " . $con->error);
    }
}






// Determine action and call respective function
$action = isset($_POST['action']) ? $_POST['action'] : null;

if ($action) {
    // Common input validation and sanitization
    $item_title = mysqli_real_escape_string($con, $_POST["item_title"] ?? "");
    $item_price = floatval($_POST["item_price"] ?? 0.0);
    $item_description = mysqli_real_escape_string($con, $_POST["item_description"] ?? "");
    $category_name = mysqli_real_escape_string($con, $_POST["category_name"] ?? "");
    $subcategory_name = mysqli_real_escape_string($con, $_POST["subcategory_name"] ?? "");
    $childcategory_name = mysqli_real_escape_string($con, $_POST["childcategory_name"] ?? "");
    $location_country = mysqli_real_escape_string($con, $_POST["location_country"] ?? "");
    $location_city = mysqli_real_escape_string($con, $_POST["location_city"] ?? "");
    $location_lat = floatval($_POST["location_lat"] ?? 0.0);
    $location_lng = floatval($_POST["location_lng"] ?? 0.0);
    $item_condition = mysqli_real_escape_string($con, $_POST["item_condition"] ?? "");
    $user_id = intval($_POST["user_id"] ?? 0);
    $images = $_FILES["images"] ?? null;
    $existingImageUrls = isset($_POST['existingImageUrls']) ? $_POST['existingImageUrls'] : null;



        switch ($action) {
            case "add":
                $response = addItem($con, $item_title, $item_price, $item_description, $category_name, $subcategory_name, $childcategory_name, $location_country, $location_city, $location_lat, $location_lng, $item_condition, $user_id, $images);
                break;
            case "update":
                $sell_id = intval($_POST["sell_id"]);
                $response = updateItem($con, $sell_id, $item_title, $item_price, $item_description, $category_name, $subcategory_name, $childcategory_name, $location_country, $location_city, $location_lat, $location_lng, $item_condition, $images, $existingImageUrls);
                break;
            case "delete":
                $sell_id = intval($_POST["sell_id"]);
                $response = deleteItem($con, $sell_id);
                break;
            case "setPremiumStatus":
                $sell_id = intval($_POST["sell_id"]);
                $is_premium = filter_var($_POST["is_premium"], FILTER_VALIDATE_BOOLEAN);
                 if (isset($_POST["duration_in_days"]) && is_numeric($_POST["duration_in_days"])) {
                        $duration_in_days = intval($_POST["duration_in_days"]);
                    } else {
                        $duration_in_days = null; // Set to null if not provided or invalid
                    }
                $response = setPremiumStatus($con, $sell_id, $is_premium, $duration_in_days);
            break;
            default:
                $response["error"] = "Invalid action specified.";
                break;
        }
   
} else {
    $response["error"] = "No action specified.";
}

echo json_encode($response);

mysqli_close($con);
?>
