<?php

require "connection.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'];

    switch ($action) {
        case 'create':
            $image_url = $_FILES["image"];
            $title = isset($_POST['title']) ? $_POST['title'] : null;
            $description = isset($_POST['description']) ? $_POST['description'] : null;
            $order = isset($_POST['order']) ? intval($_POST['order']) : null;

            createSlide($image_url, $title, $description, $order);
            break;

        case 'edit':
            $id = intval($_POST['id']);
            $image_url = $_FILES["image"];
            $title = isset($_POST['title']) ? $_POST['title'] : null;
            $description = isset($_POST['description']) ? $_POST['description'] : null;
            $order = isset($_POST['order']) ? intval($_POST['order']) : null;

            editSlide($id, $image_url, $title, $description, $order);
            break;

        case 'delete':
            $id = intval($_POST['id']);
            deleteSlide($id);
            break;

        default:
            echo "Invalid action specified.";
    }
} else {
    echo "Invalid request method.";
}


function createSlide($file, $title = null, $description = null, $order = null) {
    global $con;

    // Handle the file upload
    $uploadDir = 'uploads/slides/';
    $fileName = basename($file['name']);
    $targetFilePath = $uploadDir . $fileName;
    
    if (move_uploaded_file($file['tmp_name'], $targetFilePath)) {
        // File upload successful, save the URL in the database
        $image_url = $targetFilePath;

        $stmt = $con->prepare("INSERT INTO slides (image_url, title, description, `order`) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("sssi", $image_url, $title, $description, $order);
        
        if ($stmt->execute()) {
            echo "Slide created successfully!";
        } else {
            echo "Error: " . $stmt->error;
        }
        
        $stmt->close();
    } else {
        echo "Failed to upload the image.";
    }
}



function editSlide($id, $file, $title = null, $description = null, $order = null) {
    global $con;

    // Retrieve the current image URL before updating
    $stmt = $con->prepare("SELECT image_url FROM slides WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->bind_result($old_image_url);
    $stmt->fetch();
    $stmt->close();

    // Handle the file upload if a new file is provided
    if ($file && $file['error'] == 0) {
        $uploadDir = 'uploads/slides/';
        $fileName = basename($file['name']);
        $targetFilePath = $uploadDir . $fileName;

        if (move_uploaded_file($file['tmp_name'], $targetFilePath)) {
            $image_url = $targetFilePath;

            // Delete the old image file from the server
            if ($old_image_url && file_exists($old_image_url)) {
                unlink($old_image_url);
            }
        } else {
            echo "Failed to upload the image.";
            return;
        }
    } else {
        // No new file uploaded, keep the old image URL
        $image_url = $old_image_url;
    }

    // Update the slide information
    $stmt = $con->prepare("UPDATE slides SET image_url = ?, title = ?, description = ?, `order` = ?, updated_at = CURRENT_TIMESTAMP WHERE id = ?");
    $stmt->bind_param("sssii", $image_url, $title, $description, $order, $id);
    
    if ($stmt->execute()) {
        echo "Slide updated successfully!";
    } else {
        echo "Error: " . $stmt->error;
    }
    
    $stmt->close();
}




function deleteSlide($id) {
    global $con;

    // Retrieve the current image URL
    $stmt = $con->prepare("SELECT image_url FROM slides WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->bind_result($image_url);
    $stmt->fetch();
    $stmt->close();

    // Delete the slide from the database
    $stmt = $con->prepare("DELETE FROM slides WHERE id = ?");
    $stmt->bind_param("i", $id);
    
    if ($stmt->execute()) {
        // Delete the image file from the server
        if (file_exists($image_url)) {
            unlink($image_url);
        }
        echo "Slide deleted successfully!";
    } else {
        echo "Error: " . $stmt->error;
    }
    
    $stmt->close();
}



?>
