<?php
header('Content-Type: application/json');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require "connection.php";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'];
    $user_id = intval($_POST['user_id']);
    // $product_id = intval($_POST['product_id']);
    // $product_type = $_POST['product_type'];

    switch ($action) {
        case 'add':
            $product_id = intval($_POST['product_id']);
            $product_type = $_POST['product_type'];
            addToWishlist($user_id, $product_id, $product_type);
            break;

        case 'remove':
            $id = intval($_POST['id']);
            removeFromWishlist($id);
            break;
            
        case 'get':
                $product_id = intval($_POST['product_id']);
                $product_type = $_POST['product_type'];
            getItemFromWishlist($user_id, $product_id, $product_type);
            break;
            
        case 'getAllWishlist':
            getAllWishlistItems($user_id);
        break;

        default:
            echo "Invalid action specified.";
    }
} else {
    echo "Invalid request method.";
}



function addToWishlist($user_id, $product_id, $product_type) {
    global $con;

    // Check if the product is already in the wishlist
    $stmt = $con->prepare("SELECT id FROM wishlist_tbl WHERE user_id = ? AND product_id = ? AND product_type = ?");
    $stmt->bind_param("iis", $user_id, $product_id, $product_type);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        echo "Product is already in the wishlist.";
    } else {
        // Add product to wishlist
        $stmt = $con->prepare("INSERT INTO wishlist_tbl (user_id, product_id, product_type, added_at) VALUES (?, ?, ?, NOW())");
        $stmt->bind_param("iis", $user_id, $product_id, $product_type);

        if ($stmt->execute()) {
            echo "Product added to wishlist successfully!";
        } else {
            echo "Error: " . $stmt->error;
        }
    }
    $stmt->close();
}




function removeFromWishlist($id) {
    global $con;

    // Remove product from wishlist
    $stmt = $con->prepare("DELETE FROM wishlist_tbl WHERE id = ?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo "Product removed from wishlist successfully!";
        } else {
            echo "Product was not found in the wishlist.";
        }
    } else {
        echo "Error: " . $stmt->error;
    }
    $stmt->close();
}

function getItemFromWishlist($user_id, $product_id, $product_type) {
    global $con;

    // Determine which table to query based on the product type
    switch ($product_type) {
        case 'sell':
            $table = 'sell_tbl';
            $id_column = 'sell_id';
            break;
        case 'rent':
            $table = 'rent_tbl';
            $id_column = 'id';
            break;
        case 'donate':
            $table = 'donate_tbl';
            $id_column = 'donate_id';
            break;
        default:
            echo "Invalid product type.";
            return;
    }

    // Prepare the SQL query to fetch the item from the correct table
    $stmt = $con->prepare("SELECT * FROM $table WHERE $id_column = ?");
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $item = $result->fetch_assoc();

        // Decode the images field if it exists
        if (isset($item['images'])) {
            $decodedImages = json_decode($item['images'], true); // Decode JSON string to array
            if (json_last_error() === JSON_ERROR_NONE) {
                $item['images'] = $decodedImages; // Assign decoded array back
            } else {
                $item['images'] = []; // Handle JSON decoding error
            }
        }

        // Return the item as JSON without escaping slashes
        header('Content-Type: application/json');
        echo json_encode($item, JSON_UNESCAPED_SLASHES);
    } else {
        echo "Item not found.";
    }

    $stmt->close();
}


function getAllWishlistItems($user_id) {
    global $con;

    // Prepare the SQL query to fetch all items from wishlist_tbl for the specific user, ordered by ID in descending order
    $stmt = $con->prepare("SELECT * FROM wishlist_tbl WHERE user_id = ? ORDER BY id DESC");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $wishlistItems = [];

    // Fetch and process each wishlist item
    while ($row = $result->fetch_assoc()) {
        $product_id = $row['product_id'];
        $product_type = $row['product_type'];
        $wishlist_id = $row['id'];

        // Initialize variables
        $table = '';
        $id_column = '';

        // Determine which table to query based on the product type
        switch ($product_type) {
            case 'sell':
                $table = 'sell_tbl';
                $id_column = 'sell_id';
                break;
            case 'rent':
                $table = 'rent_tbl';
                $id_column = 'id';
                break;
            case 'donate':
                $table = 'donate_tbl';
                $id_column = 'donate_id';
                break;
            default:
                continue; // Skip this item if the product_type is invalid
        }

        // Ensure that table and id_column are properly set before executing the query
        if (!empty($table) && !empty($id_column)) {
            // Prepare the SQL query to fetch the item from the correct table
            $stmtItem = $con->prepare("SELECT * FROM $table WHERE $id_column = ?");
            $stmtItem->bind_param("i", $product_id);
            $stmtItem->execute();
            $itemResult = $stmtItem->get_result();

            if ($itemResult->num_rows > 0) {
                $item = $itemResult->fetch_assoc();
                $item['wishlist_id'] = $wishlist_id; // Add wishlist ID to the item

                // Decode the images field if it exists
                if (isset($item['images'])) {
                    $decodedImages = json_decode($item['images'], true);
                    if (json_last_error() === JSON_ERROR_NONE) {
                        $item['images'] = $decodedImages;
                    } else {
                        $item['images'] = [];
                    }
                }

                // Add the wishlist_tbl row data to the item object
                $item['wishlist_tbl'] = $row;

                $wishlistItems[] = $item; // Add the item to the wishlist items array
            }

            $stmtItem->close();
        }
    }

    // Return all wishlist items as JSON, inside a 'wishlist' object, without escaping slashes
    
    echo json_encode($wishlistItems, JSON_UNESCAPED_SLASHES);

    $stmt->close();
}








?>