<?php
require "connection.php";

$response = array();

// Assuming you have received these values from your mobile app
$search_query = isset($_POST["search_query"]) ? $_POST["search_query"] : null;

// Check if search_query is provided
if ($search_query !== null) {
    // Retrieve products based on the search query
    $searchProductsQuery = "SELECT * FROM sell_tbl WHERE 
                            item_title LIKE '%$search_query%' OR 
                            item_description LIKE '%$search_query%'";
    $searchProductsResult = mysqli_query($con, $searchProductsQuery);

    if ($searchProductsResult) {
        // Check if any products were found
        $productCount = mysqli_num_rows($searchProductsResult);

        if ($productCount > 0) {
            // Products found, fetch the results
            $products = array();

            while ($row = mysqli_fetch_assoc($searchProductsResult)) {
                $products[] = $row;
            }

            $response["error"] = "200";
            $response["message"] = "Products retrieved successfully";
            $response["product_count"] = $productCount;
            $response["products"] = $products;
        } else {
            // No products found for the search query
            $response["error"] = "404";
            $response["message"] = "No products found for the search query";
        }
    } else {
        // Error executing query
        $response["error"] = "500";
        $response["message"] = "Error executing query: " . mysqli_error($con);
    }
} else {
    // Invalid request, search_query is not provided
    $response["error"] = "400";
    $response["message"] = "Invalid request, search_query is not provided";
}

echo json_encode($response);

mysqli_close($con);
?>
