<?php
require "connection.php";

$response = array();

// Assuming you have received these values from your mobile app
$category_name = isset($_GET["category_name"]) ? $_GET["category_name"] : null;

// Check if the category_name is provided
if ($category_name !== null) {
    // Retrieve products based on the specified category
    $getProductsQuery = "SELECT * FROM sell_tbl WHERE category_name = '$category_name'";
    $getProductsResult = mysqli_query($con, $getProductsQuery);

    if ($getProductsResult) {
        // Check if any products were found
        if (mysqli_num_rows($getProductsResult) > 0) {
            // Products found, fetch the results
            $products = array();

            while ($row = mysqli_fetch_assoc($getProductsResult)) {
                $products[] = $row;
            }

            $response["error"] = "200";
            $response["message"] = "Products retrieved successfully";
            $response["products"] = $products;
        } else {
            // No products found for the specified category
            $response["error"] = "404";
            $response["message"] = "No products found for the specified category";
        }
    } else {
        // Error executing query
        $response["error"] = "500";
        $response["message"] = "Error executing query: " . mysqli_error($con);
    }
} else {
    // Invalid request, category_name is not provided
    $response["error"] = "400";
    $response["message"] = "Invalid request, category_name is not provided";
}

echo json_encode($response);

mysqli_close($con);
?>
