<?php
require "connection.php";

$response = array();

// Assuming you have received these values from your mobile app
$min_price = isset($_POST["min_price"]) ? $_POST["min_price"] : null;
$max_price = isset($_POST["max_price"]) ? $_POST["max_price"] : null;

// Check if both min_price and max_price are provided
if ($min_price !== null && $max_price !== null) {
    // Retrieve products within the specified price range
    $getProductsQuery = "SELECT * FROM sell_tbl WHERE item_price BETWEEN '$min_price' AND '$max_price'";
    $getProductsResult = mysqli_query($con, $getProductsQuery);

    if ($getProductsResult) {
        // Check if any products were found
        if (mysqli_num_rows($getProductsResult) > 0) {
            // Products found, fetch the results
            $products = array();

            while ($row = mysqli_fetch_assoc($getProductsResult)) {
                $products[] = $row;
            }

            $response["error"] = "200";
            $response["message"] = "Products retrieved successfully";
            $response["products"] = $products;
        } else {
            // No products found within the specified price range
            $response["error"] = "404";
            $response["message"] = "No products found within the specified price range";
        }
    } else {
        // Error executing query
        $response["error"] = "500";
        $response["message"] = "Error executing query: " . mysqli_error($con);
    }
} else {
    // Invalid request, min_price or max_price is not provided
    $response["error"] = "400";
    $response["message"] = "Invalid request, min_price or max_price is not provided";
}

echo json_encode($response);

mysqli_close($con);
?>
